/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;


import jp.mosp.workflow.dto.AttendanceRouteDto;
import jp.mosp.workflow.vo.AttendanceRouteListVo;

public class AttendanceRouteListAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_ROUTE_LIST_SHOW      = "S2830";
	private static final String CMD_ROUTE_LIST_SEARCH    = "S2831";
	private static final String CMD_ROUTE_LIST_RE_SEARCH = "S2832";
	private static final String CMD_ROUTE_LIST_SORT      = "S2833";

	/**
	 * RXgN^
	 */
	public AttendanceRouteListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		AttendanceRouteListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof AttendanceRouteListVo) {
			vo = (AttendanceRouteListVo)obj;
		} else {
			vo = new AttendanceRouteListVo();
		}
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// jbg擾
		vo.aryPltUnit = getCurrentUnitArray();
		// R[h
		vo.aryPltSection = util.addArrayFirstRowSpace(getSectionArrayAll());
		// ЈR[h
		vo.aryPltUser = getBasisArrayAll();
		// R}h̏
		if (cmd.equals(CMD_ROUTE_LIST_SHOW)) {
			// lɃZbg
			vo.setSearchmode(AttendanceRouteListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_ROUTE_LIST_SEARCH)) {
			// 
			vo.setParams(request);
			searchRouteList(vo);
			vo.setFormerKey(vo.KEY_SECTION);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_ROUTE_LIST_RE_SEARCH)) {
			// Č
			if (vo.getSearchmode() == AttendanceRouteListVo.SEARCH_ON) {
				session.removeAttribute(MospConst.ATT_DTO);
				searchRouteList(vo);
				vo.setPageButton();
				sortList(vo);
			}
		} else if (cmd.equals(CMD_ROUTE_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * [gXg
	 * @param vo UserListVoCX^X
	 * @throws Exception
	 */
	private void searchRouteList(AttendanceRouteListVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// 
		prepareAttendanceRouteDao();
		vo.setFields(atRouteDao.findForCondition(
				vo.getPltSection(),
				vo.getTxtKCode(),
				vo.getTxtKName(),
				vo.getTxtRouteCode()
		));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryAttendanceRoute().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
		vo.setSearchmode(AttendanceRouteListVo.SEARCH_ON);
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, AttendanceRouteListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(AttendanceRouteListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator getComparator(String key, AttendanceRouteListVo vo) throws MospException {
		Comparator comp = null;
		if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompSection implements Comparator, Serializable {
		private static final long serialVersionUID = -6704496605982974674L;
		public int compare(Object obj1, Object obj2) {
			AttendanceRouteDto dto1 = (AttendanceRouteDto)obj1;
			AttendanceRouteDto dto2 = (AttendanceRouteDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator, Serializable {
		private static final long serialVersionUID = -8076999764807189761L;
		public int compare(Object obj1, Object obj2) {
			AttendanceRouteDto dto1 = (AttendanceRouteDto)obj1;
			AttendanceRouteDto dto2 = (AttendanceRouteDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}

}
